<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${item.getPSSystemModule().codeName?lower_case}.domain;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.sql.Timestamp;

/**
 * 实体[${item.codeName}] 数据对象
 */
@Entity(name = "${item.getTableName()?lower_case}")
@Data
public class ${item.codeName}{

<#comment>输出当前实体属性</#comment>
<#list item.getPSDEFields() as defield>
<#if defield.isKeyDEField()>
    @Id
    @GeneratedValue(generator = "uuid")
    @GenericGenerator(name = "uuid", strategy = "uuid")
<#else>
    <#if defield.getDataType()!="PICKUP">
    @Column(name = "${defield.codeName?lower_case}")
    </#if>
</#if>
    <#if defield.getDataType()!="PICKUP">
    private ${srfjavatype(defield.stdDataType)} ${defield.codeName?lower_case};
    </#if>
</#list>

<#comment>输出当前实体1:N主实体</#comment>
<#if item.getMinorPSDERs?? && item.getMinorPSDERs()??>
    <#list item.getMinorPSDERs() as MinorPSDER>
        <#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
        <#assign MinorEntity = MinorPSDER.getMinorPSDataEntity()>
        <#assign wjz = MinorPSDER.getPSPickupDEField()>
    @ManyToOne//关系主表数据
    @JoinColumn(name="${wjz.getName()?lower_case}",foreignKey = @ForeignKey(name = "${MinorPSDER.getName()}"))
    private ${MajorEntity.getCodeName()} ${wjz.getName()?lower_case};
    </#list>
</#if>
<#comment>输出当前实体1:N子实体</#comment>
<#if item.getMajorPSDERs?? && item.getMajorPSDERs()??>
    <#list item.getMajorPSDERs() as MajorPSDER>
        <#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
        <#assign Entity_cap_first = MajorPSDER.getPSPickupDEField().getName()?lower_case>
    @OneToMany(mappedBy = "${Entity_cap_first}", cascade = CascadeType.ALL, orphanRemoval = true)//关系从表数据
    private List <${MinorEntity.getCodeName()}> ${MinorEntity.getCodeName()?lower_case}s = new ArrayList<>();

    public void add${MinorEntity.getCodeName()}(${MinorEntity.getCodeName()} ${MinorEntity.getCodeName()?lower_case}) {
        ${MinorEntity.getCodeName()?lower_case}s.add( ${MinorEntity.getCodeName()?lower_case} );
        ${MinorEntity.getCodeName()?lower_case}.set${Entity_cap_first?cap_first}( this );
    }

    public void remove${MinorEntity.getCodeName()}(${MinorEntity.getCodeName()} ${MinorEntity.getCodeName()?lower_case}) {
        ${MinorEntity.getCodeName()?lower_case}s.remove( ${MinorEntity.getCodeName()?lower_case} );
        ${MinorEntity.getCodeName()?lower_case}.set${Entity_cap_first?cap_first}( null );
    }
    </#list>
</#if>
<#assign str = ""/>
<#list item.getPSDEFields() as defield>
    <#if defield.getDataType()!="PICKUP">
        <#assign str = str +'"${defield.codeName?lower_case}=" +${defield.codeName?lower_case}+","+'/>
    </#if>
</#list>
    @Override
    public String toString() {

        return ${str?substring(0,str?length-5)} ;
    }

}
